
#import <Foundation/Foundation.h>

/*!
 @class NSXMutableDictionary
 A mutable dictionary class that can contain up to four key-value pairs.
 This class conforms with Cocoa memory management policy, and is implemented without ARC.

 This specification is stripped down to the core to highlight concerns that you should think of in memory management.
 Therefore, you should not use this class in any of your future program.
 
 @abstract Mutable dictionary that can contain up to four key-value pairs
 
 @see https://developer.apple.com/library/ios/documentation/Cocoa/Conceptual/MemoryMgmt/Articles/MemoryMgmt.html
 @see NSMutableDictionary
 
 */
@interface NSXMutableDictionary : NSObject


/*!
 @methodgroup adding/removing entries
 */

/*!
 @method - (void)setObject:(NSObject *)theObject forKey:(NSMutableString *)theKey error:(NSError **)theError;
 Set object associated with the given key. Replace any object in the dictionary that is currently associated with the given key.

 */
- (void)setObject:(NSObject *)theObject forKey:(NSObject *)theKey error:(NSError **)theError;
- (void)removeObjectForKey:(NSObject *)theKey;

// querying entries
- (NSObject *)objectForKey:(NSObject *)theKey;
- (NSInteger)count;
- (NSObject *)lastKeySuccessfullySet;

// deallocation (NOTE: Typically, you don't have to declare this method because it is declared in NSObject)
- (void)dealloc;

@end
